# coding: utf-8
from matplotlib import pyplot as plt # import du module capable de tracer des graphiques

U0 = 0 # valeur de la tension à vide du GBF
tensions = [] # Cette liste va stocker toutes les tensions mesurées
resistances = [] # Cette liste va stocker toutes les resistances que vous allez tester

#------------------------Valeurs de secours----------------------------#
#----- enlevez les """ avant et après si vous voulez les utiliser -----#
"""
U0=4.526
tensions=[3.93,3.754,3.465,2.81,2.566,2.234,1.784,1.5,1.124,0.645]
resistances=[400,300,200,100,80,60,40,30,20,10]
"""
#------------------------Fin Valeurs de secours------------------------#

etude = [] # définition des points de la fonction proportionnelle à Uext
for i in range(len(resistances)):
    etude.append(resistances[i] * (U0 - tensions[i]))

# (NSI) Les 3 lignes précédentes sont équivalentes à :
# etude=[resistances[i]*(U0-tensions[i]) for i in range(len(tensions))] 

def regression_lineaire(x,y):
    """
    calcule le coefficient a de la droite y = a × x par la méthode des moindres carrés
    le paramètre x est une liste d'ordonnées et y une liste d'abscisses
    la fonction retourne le coefficient a de la droite de proportionnalité la mieux alignée
    avec le nuage de points [xi, yi]
    """
    s_xy = 0
    for i in range(len(x)):
        s_xy += x[i] * y[i]
    s_x2 = 0
    for i in x:
        s_x2 += i ** 2
    return s_xy / s_x2


a = regression_lineaire(tensions,etude) # détermination de la droite de régression --> valeur de Rint

#--- Affichage des résultats dans le shell ---#
print("tensions = ",tensions)
print("resistances = ",resistances)

#--- Tracé du graphique ---#
# tracé de la droite de régression à l'aide des 2 valeurs extrêmes
plt.plot((min(tensions), max(tensions)), (a*min(tensions), a*max(tensions)), color="blue")

# tracé des points de mesure
plt.plot(tensions, etude, "r.")

# Ces 3 lignes se contentent d'afficher l'équation de la droite à l'endroit voulu (en haut à gauche)
x = min(tensions) + 0.01 * (max(tensions) - min(tensions)) 
y = min(etude) + 0.99*(max(etude) - min(etude))
plt.text(x, y, "droite de régression y="+str(round(a,2))+"x", verticalalignment='center', fontsize=14, color='r')

#Affichage du graphique
plt.show() 
